<?php $__env->startSection('title', 'Productos'); ?>

<?php $__env->startSection('content_header'); ?>

    <h1>Lista de Productos</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">

        
        <form action="<?php echo e(route('admin.productos.index')); ?>" method="GET" class="d-flex align-items-center" style="gap: 10px;">
            
            <select name="almacen" class="form-control">
                <option value="">Todos los almacenes</option>
                <?php $__currentLoopData = $almacenes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $alm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e(trim($alm->Des_item)); ?>" <?php echo e(request('almacen') == trim($alm->Des_item) ? 'selected' : ''); ?>>
                        <?php echo e($alm->Des_item); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>

            
            

            
            <button class="btn btn-primary" type="submit">Aplicar filtro</button>
        </form>




        
        <?php echo $__env->make('admin.paginador.index', ['data' => $data], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
    <div class="card-header d-flex justify-content-between align-items-center">
         
         <form action="<?php echo e(route('admin.productos.index')); ?>" method="GET" class="d-flex align-items-center" style="gap: 10px;">
            
            <input name="search" class="form-control" type="text" placeholder="Buscar productos por, nombre, codigo, familia o linea" value="<?php echo e(request('search')); ?>" autocomplete="off">

            
            <input type="hidden" name="almacen" value="<?php echo e(request('almacen')); ?>">

            
            <button class="btn btn-primary" type="submit">Buscar</button>
        </form>
    </div>
    
    <?php if($data['items']->count()): ?>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-hover">
                    <thead class="border text-center">
                        <tr>
                            <th>ID</th> 
                            <th>Código</th>
                            <th>Descripción</th>
                            <th>Familia</th>
                            <th>Línea</th>
                            <th>Tipo</th>
                            <th>Unidad de Medida</th>
                            <th>Precio (S/.)</th>
                            <th>Precio (USD)</th>
                            <th>Stock Actual</th>
                            <th>Estado</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $data['items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $producto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($data['tamanio'] * ($data['pagina'] - 1) + $loop->iteration); ?></td>
                                <td><?php echo e($producto->Cdg_prod); ?></td>
                                <td><?php echo e($producto->Des_prod); ?></td>
                                <td><?php echo e($producto->Familia); ?></td>
                                <td><?php echo e($producto->Linea); ?></td>
                                <td><?php echo e($producto->Tipo); ?></td>
                                <td><?php echo e($producto->UNM); ?></td>
                                <td><?php echo e($producto->Val_sol); ?></td>
                                <td><?php echo e($producto->Val_dol); ?></td>
                                <td><?php echo e($producto->Stk_act); ?></td>
                                <td><?php echo e($producto->swt_est == 1 ? 'Activo' : 'Inactivo'); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    <?php else: ?>
        
        <div class="card-body text-center">
            <strong>No se encontraron registros con los filtros aplicados.</strong>
        </div>
    <?php endif; ?>
</div>



<?php $__env->stopSection(); ?>



<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\Sistema-web\resources\views/admin/productos/index.blade.php ENDPATH**/ ?>