<?php $__env->startSection('title', 'Registrar Distribuidor'); ?>

<?php $__env->startSection('content_header'); ?>
    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    
    <div class="card">
        <h5 class="card-header text-white bg-info">Registrar Distribuidor</h5>
        <div class="card-body">
            <form method="POST" action="<?php echo e(route('admin.distribuidores.store')); ?>">
                <?php echo csrf_field(); ?>
                <div class="form-row">
                    <div class="col-md-4">
                        <label>Código Distribuidor</label>
                        <input type="text" class="form-control" name="cod_dist" id="cod_dist"  placeholder="Ingrese el código" readonly>
                    </div>
                    <div class="col-md-4">
                        <label>Código Cliente</label>
                        <input type="text" class="form-control" placeholder="Ingrese el código cliente" name="cod_cli" id="cod_cli" readonly>
                    </div>
                    <div class="col-md-4">
                        <label>N° Dni</label>
                        <input type="text" class="form-control" placeholder="Ingrese DNI" name="dni" id="dni" oninput="digito(this,8)" required>
                        <span class="text-danger">* campo obligatorio</span>
                    </div>
                    
                </div>
    
                <div class="form-row">
                    <div class="col-md-4">
                        <label for=nombre"">Nombres</label>
                        <input type="text" class="form-control" name="nombre" id="nombre" placeholder="Ingrese nombres" onkeyup="llenardistribuidor()" required>
                   <span class="text-danger">* campo obligatorio</span>
                    </div>
                    <div class="col-md-4">
                        <label for="paterno">Apellido Paterno</label>
                        <input type="text" class="form-control" name="paterno" id="paterno" placeholder="Ingrese apellido materno" onkeyup="llenardistribuidor()" required>
                    <span class="text-danger">* campo obligatorio</span>
                    </div>
                    <div class="col-md-4">
                        <label for="materno">Apellido Materno</label>
                        <input type="text" class="form-control" name="materno" id="materno" placeholder="Ingrese apellido materno" onkeyup="llenardistribuidor()" required>
                    <span class="text-danger">* campo obligatorio</span>
                    </div>
                    <div class="col-md-2">
                        <label>Fecha Nac</label>
                        <input type="date" class="form-control" name="nacimiento" id="nacimiento">
                    </div>
                    <div class="col-md-2">
                        <label>Estado civil</label>
                        <select name="estadoC" id="estadoC" class="form-control">
                         <option value="000">--seleccione</option>
                         <option value="001">Soltero</option>
                         <option value="002">Casado</option>
                         <option value="003">Divorciado</option>
                         <option value="004">Conviviente</option>
                         <option value="005">Viudo</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label>Sexo</label>
                        <select name="sexo" id="sexo" class="form-control">
                            <option value="">--Selecciona</option>
                            <option value="1">Masculino</option>
                            <option value="2">Femenino</option>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label for="distribuidor">Distribuidor</label>
                        <input type="text" class="form-control" name="distribuidor" id="distribuidor"  readonly>
                    </div>
                </div>
    
                <div class="form-row">
                    <div class="col-md-3">
                        <p class="text-black">asigna </p>
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" type="radio" name="asignar" id="asignar1" value="option1" checked onchange="elegir()">
                            <label class="form-check-label" for="inlineCheckbox1">asignar mismo patrocinador</label>
                        </div>
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" type="radio" name="asignar" id="asignar2" value="option2" onchange="elegir()">
                            <label class="form-check-label" for="inlineCheckbox2">asignar a otro</label>
                        </div>
                    </div>
                    <div class="col-md-3" id="patrocinaE">
                        <label>Patrocinador</label>
                        <select class="form-control" name="patrocinador" id="patrocinador">
                            <?php $__currentLoopData = $patrocinadores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $patrocinador): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($patrocinador->cdg_dist); ?>"><?php echo e($patrocinador->Nombre); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-md-3"  id="patrocinaD" style="display: none">
                        <label>Distribuidore del Patrocinador</label>
                        <select class="form-control" name="DistriP">
                            <option value="">--Seleccione--</option>
                            <?php $__currentLoopData = $distribuidores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $distribuidore): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($distribuidore->cdg_dist); ?>"><?php echo e($distribuidore->Nombre); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label>telefono</label>
                        <input type="text" class="form-control" placeholder="999 999 999" name="telefono" id="telefono" oninput="digitotele(this,11)">
                    </div>
                    <div class="col-md-3">
                        <label>Email</label>
                        <input type="email" id="email" name="email" class="form-control" placeholder="Ingrese correo electronico">
                    </div>
                </div>
                <div class="form-row">
                    <div class="col-md-3">
                        <label for="pais">Pais</label>
                        <select class="form-control" name="pais" id="pais" onchange="buscar_departamento()" required>
                            <option value="">--Seleccione--</option>
                            <?php $__currentLoopData = $paises; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pais): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($pais->cdg_pais); ?>"><?php echo e($pais->des_pais); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <span class="text-danger">* campo obligatorio</span>
                    </div>
                    <div class="col-md-3">
                        <label for="departamento">Departamento</label>
                        <select class="form-control" name="departamento" id="departamento" onchange="buscar_provincia()" required>
                            <option value="">--Seleccione--</option>
                            
                        </select>
                        <span class="text-danger">* campo obligatorio</span>
                    </div>
                    <div class="col-md-3">
                        <label for="provincia">Provincia</label>
                        <select class="form-control" name="provincia" id="provincia" onchange="buscar_distrito()">
                            <option value="">--Seleccione--</option>
                            
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label for="distrito">Distrito</label>
                        <select class="form-control" name="distrito" id="distrito">
                            <option value="">--Seleccione--</option>
                            
                        </select>
                    </div>
                    <div class="col-md-12">
                        <label>Direccion</label>
                        <input type="text" class="form-control" placeholder="Ingrese direccion" name="direccion" id="direccion">
                    </div>
                </div>
                <div class="form-row">
                    <div class="col-md-3">
                        <label>Tipo Persona</label>
                        <select class="form-control" name="document" id="document" onchange="selecDocumt()" required>
                            <option value="">--Seleccione--</option>
                            <?php $__currentLoopData = $documentos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $documento): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                             <option value="<?php echo e($documento->cdg_docum); ?>"><?php echo e($documento->descripcion); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select> 
                        <span class="text-danger">* campo obligatorio</span>
                    </div>
                    <div class="col-md-3">
                        <label>Tipo Condicion</label>
                        <select class="form-control" name="condicion" id="condicion">
                            <option value="">--Seleccione--</option>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label>Lista Precio</label>
                        <select class="form-control" name="lisprecio" id="lisprecio">
                            <option value="">--Seleccione--</option>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label>Vendedor</label>
                        <select class="form-control" name="vendedor" id="vendedor" required>
                            <option value="">--Seleccione--</option>
                            <?php $__currentLoopData = $vendedores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vendedor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($vendedor->Cdg_vend); ?>"><?php echo e($vendedor->Des_vend); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <span class="text-danger">* campo obligatorio</span>
                    </div>
                    <div class="col-md-12">
                        <label>Observacion</label>
                        <textarea class="form-control" id="observacion" name="observacion" rows="3"></textarea>
                    </div>
                </div>
                <div class="form-row mt-3 ml-3">
                    <div class="col-sm-1">
                        <input class="form-check-input" type="checkbox" id="activo" name="activo" value="1">
                          <label class="form-check-label" for="gridCheck">
                            Activo
                          </label>
                    </div>
                    <div class="col-md-3">
                        <label for="">suspendido</label>
                        <div class="form-check">
                            <input class="form-check-input" type="radio" name="supendido" id="supendido1" value="1" >
                            <label class="form-check-label" for="exampleRadios1">
                              si
                            </label>
                          </div>
                          <div class="form-check">
                            <input class="form-check-input" type="radio" name="supendido" id="supendido2" value="0">
                            <label class="form-check-label" for="exampleRadios2">
                              No
                            </label>
                          </div>
                    </div>
                    <div class="col-md-3">
                        <label for="">Procedencia</label>
                        <div class="form-check">
                            <input class="form-check-input" type="radio" name="procedencia" id="procedencia1" value="1">
                            <label class="form-check-label" for="exampleRadios1">
                              Nacional
                            </label>
                          </div>
                          <div class="form-check">
                            <input class="form-check-input" type="radio" name="procedencia" id="procedencia2" value="2">
                            <label class="form-check-label" for="exampleRadios2">
                              Extranjera
                            </label>
                          </div>
                    </div>
                    <div class="col-md-3">
                        <label for="">Tiene RUC</label>
                        <div class="form-check">
                            <input class="form-check-input" type="radio" name="ruc" id="ruc1" value="1" onchange="tienRuc()">
                            <label class="form-check-label" for="exampleRadios1"> 
                              Si
                            </label>
                          </div>
                          <div class="form-check">
                            <input class="form-check-input" type="radio" name="ruc" id="ruc2" value="0" onchange="tienRuc()">
                            <label class="form-check-label" for="exampleRadios2">
                              No
                            </label>
                          </div>
                    </div>
                </div>
                <div class="form-row mt-2">
                    <div class="col-md-3">
                        <label for="">Tipo Cliente</label>
                        <div class="form-check">
                            <input class="form-check-input" type="radio" name="tipoclien" id="tipoclien1" value="1">
                            <label class="form-check-label" for="exampleRadios1">
                              Persona Juridica
                            </label>
                          </div>
                          <div class="form-check">
                            <input class="form-check-input" type="radio" name="tipoclien" id="tipoclien2" value="2">
                            <label class="form-check-label" for="exampleRadios2">
                              Persona Natural
                            </label>
                          </div>
                          <div class="form-check">
                            <input class="form-check-input" type="radio" name="tipoclien" id="tipoclien3" value="3">
                            <label class="form-check-label" for="exampleRadios2">
                              No Domiciliado
                            </label>
                          </div>
                          <span class="text-danger">* campo obligatorio</span>
                    </div>
                    
                    <div class="col-md-3">
                        <label>Fecha de Afiliacion</label>
                        <input type="date" class="form-control" value="<?php echo e(date("Y-m-d")); ?>" name="fecA">
                    </div>
                    <div class="col-md-3">
                        <label>N R.U.C.</label>
                        <input type="text" class="form-control" placeholder="ingresa ruc"  name="numruc" id="numruc" disabled>
                    </div>
                </div>
                <div class="form-row mt-5">
                    <div class="col-md-4 d-flex content-end">
                        <button type="submit" class="btn btn-danger">Cancelar</button>
                        <button type="submit" class="btn btn-primary ml-3">Guardar</button>
                    </div>
                </div>
            </div>
                  
        </form>
        </div>
      </div>
    
      <script>
        function digito(input,maxdigitos){
            input.value=input.value.replace(/\D/g,'');
            if(input.value.length>maxdigitos){
                input.value=input.value.slice(0,maxdigitos)
            }
        }
        function digitotele(input,maxdigitos){
            input.value=input.value.replace(/\D/g,'');
            if(input.value.length>maxdigitos){
                input.value=input.value.slice(0,maxdigitos)
            }
        }
        function llenardistribuidor(){
            let nombre=$('#nombre').val();
            let paterno=$('#paterno').val();
            let materno=$('#materno').val();
            $('#distribuidor').val(paterno +' '+ materno +' '+ nombre);
        }
       
        function buscar_departamento(){
            let codigo_pais=$('#pais').val();
            $.ajax({
                type:"POST",
                dataType: "json",
                data:{
                    "codigo_pais": codigo_pais,
                    '_token': $('meta[name="csrf-token"]').attr('content'),
                },
                url:"<?php echo e(route('admin.distribuidores.departamento')); ?>",
                success:function(resultado){
                    $('#departamento').html(resultado.html)
                }
            })


        }

        function buscar_provincia(){
            let codigo_pais=$('#pais').val();
            let codigo_departamento=$('#departamento').val();
            //console.log(codigo_pais+''+codigo_departamento);
            $.ajax({
                type:"POST",
                dataType: "json",
                data:{
                    "codigo_pais": codigo_pais,
                    "codigo_departamento": codigo_departamento,
                    '_token': $('meta[name="csrf-token"]').attr('content'),
                },
                url:"<?php echo e(route('admin.distribuidores.provincia')); ?>",
                success:function(resultado){
                    $('#provincia').html(resultado.html)
                }
            })
        }

        function buscar_distrito(){
            let codigo_pais=$('#pais').val();
            let codigo_provincia=$('#provincia').val();
            console.log(codigo_pais+''+codigo_provincia);
            $.ajax({
                type:"POST",
                dataType: "json",
                data:{
                    "codigo_pais": codigo_pais,
                    "codigo_provincia": codigo_provincia,
                    '_token': $('meta[name="csrf-token"]').attr('content'),
                },
                url:"<?php echo e(route('admin.distribuidores.distrito')); ?>",
                success:function(resultado){
                    $('#distrito').html(resultado.html)
                }
            })
        }

        function selecDocumt(){
            let tipodocu=$('#document').val();
            if(tipodocu.trim() === '6'){
                $('#tipoclien1').val("1").prop('checked',true);
                $('#ruc1').val("1").prop('checked',true);
                $('#procedencia1').val("1").prop('checked',true);
                $('#numruc').prop('disabled',false)
            }else if(tipodocu.trim() === '4'){
            
                $('#tipoclien2').val("2").prop('checked',true);
                $('#ruc2').val("0").prop('checked',true);
                $('#procedencia2').val("2").prop('checked',true)
                $('#numruc').prop('disabled',true)
            }else{
                $('#tipoclien2').val("2").prop('checked',true);
                $('#ruc2').val("0").prop('checked',true);
                $('#procedencia1').val("1").prop('checked',true)
                $('#numruc').prop('disabled',true)
            }
        }

        function elegir(){
            if($('#asignar1').is(':checked')){
                $('#patrocinaE').show();
                $('#patrocinaD').hide();
            }else if($('#asignar2').is(':checked')){
                $('#patrocinaE').hide();
                $('#patrocinaD').show();
            }
        }

        function tienRuc(){
        let ruc1 = $('#ruc1').is(':checked'); 
        let ruc2 = $('#ruc2').is(':checked');
        if(ruc1){
        $('#numruc').prop('disabled',false)
        }else if(ruc2){
        $('#numruc').prop('disabled',true)
        }
        }
      </script>
    
<?php $__env->stopSection(); ?>


<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\Sistema-web\resources\views/admin/distribuidores/create.blade.php ENDPATH**/ ?>