<nav aria-label="Page navigation">
    <ul class="pagination mb-0">
        
        <li class="page-item <?php echo e($data['pagina'] == 1 ? 'disabled' : ''); ?>">
            <a class="page-link" href="?pagina=<?php echo e($data['pagina'] - 1); ?>&search=<?php echo e($data['search']); ?>&tamanio=<?php echo e($data['tamanio']); ?>">‹</a>
        </li>

        
        <?php
            $start = max(1, $data['pagina'] - 2);
            $end = min($data['total_paginas'], $data['pagina'] + 2);
        ?>

        
        <?php if($start > 1): ?>
            <li class="page-item">
                <a class="page-link" href="?pagina=1&search=<?php echo e($data['search']); ?>&tamanio=<?php echo e($data['tamanio']); ?>">1</a>
            </li>
            <?php if($start > 2): ?>
                <li class="page-item disabled"><span class="page-link">...</span></li>
            <?php endif; ?>
        <?php endif; ?>

        
        <?php for($i = $start; $i <= $end; $i++): ?>
            <li class="page-item <?php echo e($data['pagina'] == $i ? 'active' : ''); ?>">
                <a class="page-link" href="?pagina=<?php echo e($i); ?>&search=<?php echo e($data['search']); ?>&tamanio=<?php echo e($data['tamanio']); ?>"><?php echo e($i); ?></a>
            </li>
        <?php endfor; ?>

        
        <?php if($end < $data['total_paginas']): ?>
            <?php if($end < $data['total_paginas'] - 1): ?>
                <li class="page-item disabled"><span class="page-link">...</span></li>
            <?php endif; ?>
            <li class="page-item">
                <a class="page-link" href="?pagina=<?php echo e($data['total_paginas']); ?>&search=<?php echo e($data['search']); ?>&tamanio=<?php echo e($data['tamanio']); ?>"><?php echo e($data['total_paginas']); ?></a>
            </li>
        <?php endif; ?>

        
        <li class="page-item <?php echo e($data['pagina'] == $data['total_paginas'] ? 'disabled' : ''); ?>">
            <a class="page-link" href="?pagina=<?php echo e($data['pagina'] + 1); ?>&search=<?php echo e($data['search']); ?>&tamanio=<?php echo e($data['tamanio']); ?>">›</a>
        </li>
    </ul>
</nav>
<?php /**PATH C:\laragon\www\Sistema-web\resources\views/admin/paginador/index.blade.php ENDPATH**/ ?>