<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('content_header'); ?>
    <a href="<?php echo e(route('admin.users.index')); ?>" class="float-right mt-2">
        <i class="fas fa-chevron-circle-left"></i> Ver lista de usuarios
    </a>
    <h1 class="text-bold">Ver Usuario</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header d-flex flex-wrap justify-content-between align-items-center">
            <h5 class="flex-grow-1">Usuario: <span class="badge badge-warning"><?php echo e($user->name); ?></span></h5>
            <a href="<?php echo e(route('admin.users.edit', $user)); ?>" class="btn btn-sm btn-success text-nowrap">
                <i class="fas fa-pen"></i> Editar
            </a>
        </div>
        <div class="card-body">
            <ul class="list-group">
                <li class="list-group-item">
                    <b style="min-width:100px; display: inline-block">Nombre:</b> <?php echo e($user->name); ?>

                </li>
                <li class="list-group-item">
                    <b style="min-width:100px; display: inline-block">Usuario web:</b> <?php echo e($user->email); ?>

                </li>
                <li class="list-group-item">
                    <b style="min-width:100px; display: inline-block">Rol:</b>
                    <?php if($user->roles->count()): ?>
                        <td>
                            <?php $__currentLoopData = $user->roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $userrol): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <span class="badge badge-secondary text-nowrap">
                                    <?php echo e($userrol->name); ?>

                                </span>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </td>
                    <?php else: ?>
                        <td>
                            <span class="badge badge-warning text-nowrap">
                                Sin rol
                            </span>
                        </td>
                    <?php endif; ?>
                </li>
            </ul>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <?php if(session('success') == 'update'): ?>
        <script>
            Swal.fire({
                icon: 'success',
                title: 'El usuario se editó con éxito',
            })
        </script>
    <?php endif; ?>
    <?php if(session('success') == 'store'): ?>
        <script>
            Swal.fire({
                icon: 'success',
                title: 'El usuario se creó con éxito',
            })
        </script>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\Sistema-web\resources\views/admin/users/show.blade.php ENDPATH**/ ?>