<?php $__env->startSection('title', 'Listado de Pedidos'); ?>

<?php $__env->startSection('content_header'); ?>
<a class="btn btn-primary float-right mb-3 mb-md-0" href="<?php echo e(route('admin.pedidos.create')); ?>">
    <i class="fas fa-plus-circle"></i> Registrar Pedido
</a>
    <h1 class="text-bold">Lista de Pedidos</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Livewire Component -->
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            
            <form action="<?php echo e(route('admin.pedidos.index')); ?>" method="GET" class="d-flex" style="gap: 10px; width: 50%;">
                <input name="search" class="form-control" type="text" placeholder="Buscar por Número de Pedido, Vendedor, Ruc o Cliente" value="<?php echo e(request('search')); ?>">
                <button class="btn btn-primary" type="submit">Buscar</button>
            </form>

            
            <?php echo $__env->make('admin.paginador.index', ['data' => $data], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>

        
        <?php if($data['pedidos']->count()): ?>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover">
                        <thead class="border text-center">
                            <tr>
                                <th>ID</th>
                                <th>Número</th>
                                <th>Vendedor</th>
                                <th>Forma de Pago</th>
                                <th>Moneda</th>
                                <th>Fecha Pedido</th>
                                <th>Orden Compra</th>
                                <th>Cotización</th>
                                <th>RUC Cliente</th>
                                <th>Cliente</th>
                                <th>Fecha Entrega</th>
                                <th>Fecha Vencimiento</th>
                                <th>Almacén</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $data['pedidos']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pedido): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($data['tamanio'] * ($data['pagina'] - 1) + $loop->iteration); ?></td>
                                    <td><?php echo e($pedido->Num_ped); ?></td>
                                    <td><?php echo e($pedido->Des_vend); ?></td>
                                    <td><?php echo e($pedido->FOR_PAGO); ?></td>
                                    <td><?php echo e($pedido->MONEDA); ?></td>
                                    <td><?php echo e($pedido->Fec_ped); ?></td>
                                    <td><?php echo e($pedido->Num_ocom); ?></td>
                                    <td><?php echo e($pedido->Num_cot); ?></td>
                                    <td><?php echo e($pedido->Ruc_cli); ?></td>
                                    <td><?php echo e($pedido->Des_cli); ?></td>
                                    <td><?php echo e($pedido->FEC_ENT); ?></td>
                                    <td><?php echo e($pedido->FEC_VENC); ?></td>
                                    <td><?php echo e($pedido->ALMACEN); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        <?php else: ?>
            <div class="card-body">
                <strong>Sin registros</strong>
            </div>
        <?php endif; ?>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\Sistema-web\resources\views/admin/pedidos/index.blade.php ENDPATH**/ ?>