<div class="container mt-4">
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Registrar Cotización</h3>
            <a href="#" class="btn btn-success float-right">
                <i class="fas fa-plus-circle"></i> Registrar Nueva
            </a>
        </div>

        <div class="card-body">
            <form wire:submit.prevent="guardarCotizacion">
                <div class="row">
                    <!-- Número -->
                    <div class="col-md-3">
                        <label for="numero">Número</label>
                        <input type="text" id="numero" class="form-control" wire:model="numero">
                    </div>

                    <!-- Vendedor -->
                    <div class="col-md-3">
                        <label for="vendedor">Vendedor</label>
                        <select id="vendedor" class="form-control" wire:model="vendedor">
                            <option value="">Seleccione...</option>
                            <option value="1">CESAR TEJADA LAGUNA</option>
                        </select>
                    </div>

                    <!-- Forma de Pago -->
                    <div class="col-md-3">
                        <label for="forma_pago">Forma de Pago</label>
                        <select id="forma_pago" class="form-control" wire:model="forma_pago">
                            <option value="">Seleccione...</option>
                            <option value="contado">Contado</option>
                            <option value="credito">Crédito</option>
                        </select>
                    </div>

                    <!-- Moneda -->
                    <div class="col-md-3">
                        <label for="moneda">Moneda</label>
                        <select id="moneda" class="form-control" wire:model="moneda">
                            <option value="">Seleccione...</option>
                            <option value="sol">Soles</option>
                            <option value="usd">Dólares</option>
                        </select>
                    </div>
                </div>

                <div class="row mt-3">
                    <!-- Orden de Compra -->
                    <div class="col-md-3">
                        <label for="orden_compra">Orden de Compra</label>
                        <input type="text" id="orden_compra" class="form-control" wire:model="orden_compra">
                    </div>

                    <!-- RUC -->
                    <div class="col-md-3">
                        <label for="ruc">RUC</label>
                        <input type="text" id="ruc" class="form-control" wire:model="ruc">
                    </div>

                    <!-- Razón Social -->
                    <div class="col-md-3">
                        <label for="razon_social">Razón Social</label>
                        <input type="text" id="razon_social" class="form-control" wire:model="razon_social">
                    </div>

                    <!-- Almacén -->
                    <div class="col-md-3">
                        <label for="almacen">Almacén</label>
                        <select id="almacen" class="form-control" wire:model="almacen">
                            <option value="1">Cliente/Proveedor</option>
                        </select>
                    </div>
                </div>

                <!-- Detalle de productos -->
                <div class="mt-4">
                    <h5>Detalle de Productos</h5>
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>Item</th>
                                <th>Código</th>
                                <th>Producto</th>
                                <th>Cantidad</th>
                                <th>Valor</th>
                                <th>Precio</th>
                                <th>% Dscto</th>
                                <th>Total</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- Aquí puedes agregar dinámicamente los productos mediante Livewire o Laravel -->
                        </tbody>
                    </table>
                </div>

                <!-- Totales -->
                <div class="row mt-3">
                    <div class="col-md-3">
                        <label for="subtotal">Subtotal</label>
                        <input type="text" id="subtotal" class="form-control" wire:model="subtotal" readonly>
                    </div>
                    <div class="col-md-3">
                        <label for="descuento">Descuento</label>
                        <input type="text" id="descuento" class="form-control" wire:model="descuento" readonly>
                    </div>
                    <div class="col-md-3">
                        <label for="igv">IGV</label>
                        <input type="text" id="igv" class="form-control" wire:model="igv" readonly>
                    </div>
                    <div class="col-md-3">
                        <label for="total">Total</label>
                        <input type="text" id="total" class="form-control" wire:model="total" readonly>
                    </div>
                </div>

                <!-- Botón Guardar -->
                <button type="submit" class="btn btn-primary mt-3">Guardar Cotización</button>
            </form>
        </div>
    </div>
</div>
<?php /**PATH C:\laragon\www\Sistema-web\resources\views/livewire/cotizaciones/formulario.blade.php ENDPATH**/ ?>