<div class="form-group">
    <label for="name" class="font-weight-bold">Nombre del rol</label>
    <input type="text" name="name" id="name" class="form-control" placeholder="Ingrese el nombre del rol" value="{{ old('name') }}">
    @error('name')
        <small class="text-danger">{{ $message }}</small>
    @enderror
</div>

<h5 class="font-weight-bold">Lista de permisos</h5>
<div class="accordion" id="permissionsAccordion">
    @foreach ($permissions->groupBy('category') as $category => $groupedPermissions)
        <div class="card mb-3">
            <div class="card-header" id="heading-{{ $category }}">
                <h5 class="mb-0">
                    <button class="btn btn-link" type="button" data-toggle="collapse" data-target="#collapse-{{ $category }}" aria-expanded="true" aria-controls="collapse-{{ $category }}">
                        {{ ucfirst($category) }}
                    </button>
                </h5>
            </div>
            <div id="collapse-{{ $category }}" class="collapse show" aria-labelledby="heading-{{ $category }}" data-parent="#permissionsAccordion">
                <div class="card-body">
                    <ul class="list-group">
                        @foreach ($groupedPermissions as $permission)
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <label>
                                    <input type="checkbox" name="permissions[]" value="{{ $permission->id }}" class="mr-2"
                                        {{ in_array($permission->id, old('permissions', [])) ? 'checked' : '' }}>
                                    {{ $permission->description }}
                                </label>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    @endforeach
</div>
