@extends('adminlte::page')

@section('title', 'Generar Permisos')

@section('content_header')
    <h1>Permisos Generados</h1>
@stop

@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Estructura de Permisos</h3>
        </div>
        <div class="card-body">
            <ul class="list-group">
                @foreach ($structuredPermissions as $item)
                    <li class="list-group-item">
                        <i class="{{ $item['icon'] }}"></i> {{ $item['text'] }}
                        @if (!empty($item['route']))
                            <small class="text-muted">(Permiso: {{ $item['route'] }})</small>
                        @endif
                        @if (!empty($item['submenu']))
                            <ul class="mt-2">
                                @include('admin.roles.partials.submenu', ['submenu' => $item['submenu']])
                            </ul>
                        @endif
                    </li>
                @endforeach
            </ul>
        </div>
    </div>
@stop
