@extends('adminlte::page')

@section('title', 'Editar Rol')

@section('content_header')
    <a href="{{ route('admin.roles.index') }}" class="float-right mt-2">
        <i class="fas fa-chevron-circle-left"></i> Ver lista de roles
    </a>
    <h1 class="text-bold">Editar Rol</h1>
@stop

@section('content')
    <div class="card">
        <div class="card-header d-flex flex-wrap justify-content-between align-items-center">
            <h5 class="flex-grow-1">Rol: <span class="badge badge-warning">{{ $role->name }}</span></h5>
            <a href="{{ route('admin.roles.show', $role) }}" class="btn btn-sm btn-info text-nowrap">
                <i class="fas fa-eye"></i> Ver
            </a>
        </div>
        <div class="card-body">
            <form action="{{ route('admin.roles.update', $role) }}" method="POST">
                @csrf
                @method('PUT')

                <!-- Campo de nombre del rol -->
                <div class="form-group">
                    <label for="name" class="font-weight-bold">Nombre del rol</label>
                    <input type="text" name="name" id="name" class="form-control"
                        value="{{ old('name', $role->name) }}">
                    @error('name')
                        <small class="text-danger">{{ $message }}</small>
                    @enderror
                </div>

                <!-- Lista de permisos estructurados -->
                <div class="form-group">
                    <h5 class="font-weight-bold">Lista de Permisos</h5>
                    <ul class="list-group">
                        @foreach ($structuredPermissions as $category)
                            <li class="list-group-item">
                                <i class="fas fa-folder-open"></i> {{ $category['text'] }}
                                @if (!empty($category['submenu']))
                                    <ul class="list-group mt-2">
                                        @foreach ($category['submenu'] as $permission)
                                            <li class="list-group-item">
                                                <label>
                                                    <input type="checkbox" name="permissions[]"
                                                        value="{{ $permission['route'] }}" class="mr-2"
                                                        {{ in_array($permission['route'], $selectedPermissions) ? 'checked' : '' }}>
                                                    <i class="{{ $permission['icon'] }}"></i> {{ $permission['text'] }}
                                                </label>
                                            </li>
                                            @if (!empty($permission['submenu']))
                                                <ul class="mt-2 submenu-list">
                                                    @foreach ($permission['submenu'] as $subpermission)
                                                        <li class="list-group-item">
                                                            <label>
                                                                <input type="checkbox" name="permissions[]"
                                                                    value="{{ $subpermission['route'] }}" class="mr-2"
                                                                    {{ in_array($subpermission['route'], $selectedPermissions) ? 'checked' : '' }}>
                                                                <i class="{{ $subpermission['icon'] }}"></i>
                                                                {{ $subpermission['text'] }}
                                                            </label>
                                                        </li>
                                                    @endforeach
                                                </ul>
                                            @endif
                                        @endforeach
                                    </ul>
                                @endif
                            </li>
                        @endforeach
                    </ul>
                </div>

                <!-- Botones de acción -->
                <div class="float-right">
                    <button type="submit" class="btn btn-primary">Actualizar</button>
                    <a href="{{ url()->previous() }}" class="btn btn-danger ml-1">Cancelar</a>
                </div>
            </form>
        </div>
    </div>
@stop

@section('js')
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            document.querySelectorAll('.list-group-item > .fas').forEach(icon => {
                icon.addEventListener('click', function() {
                    const submenu = this.closest('li').querySelector('.submenu-list');
                    if (submenu) {
                        submenu.style.display = submenu.style.display === 'none' ? 'block' : 'none';
                        this.classList.toggle('fa-folder-open');
                        this.classList.toggle('fa-folder');
                    }
                });
            });
        });
    </script>
@stop
