@extends('adminlte::page')

@section('title', 'Registrar Pedido')

@section('content_header')
    <h1 class="text-bold">Registrar Pedido</h1>
@stop

@section('content')
    <form action="{{ route('admin.pedidos.store') }}" method="POST">
        @csrf

        <div class="card-body">
            <!-- Formulario de Registro de Cotización -->
            <div class="card-body">

                <div class="row">
                    <!-- Columna izquierda -->
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="ruc_dni">RUC/DNI</label>
                                    <div class="input-group">
                                        <input  type="text" name='ruc_dni' id="ruc_dni"  class="form-control"
                                            placeholder="Ingrese RUC o DNI">
                                        <div class="input-group-append">
                                            <button type="button" class="btn btn-info" data-toggle="modal"
                                                data-target="#modalBuscarCliente">
                                                ...
                                            </button>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-row">

                                    <div class="form-group col-md-6">
                                        <label for="nombre_cliente">Nombre del Cliente</label>
                                        <input type="text"  id="nombre_cliente" id="nombre_cliente" class="form-control"
                                            placeholder="Nombre del Cliente">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="direccion">Dirección</label>
                                    <input name='Dir_cli' type="text" name='direccion' id="direccion" class="form-control"
                                        placeholder="Dirección">
                                </div>
                                <div class="form-group">
                                    <label for="correo">Correo</label>
                                    <input type="email" name='correo' id="correo" class="form-control"
                                        placeholder="Correo">
                                </div>
                                <div class="form-group">
                                    <label for="vendedor">Vendedor</label>
                                    <select name='vendedor' id="vendedor" class="form-control">
                                        <option value="000">selecciona vendedor</option>
                                        @foreach ($vendedores as $vendedor)
                                            <option value="{{$vendedor->Cdg_vend}}">{{$vendedor->Des_vend}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Columna derecha -->
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header bg-primary text-white text-center">
                                <h4>PEDIDO</h4>
                                {{-- Mostrar un número preliminar --}}
                                <h2 class="font-weight-bold"><input type="text" name="nuevopedido" value="{{$binarioResultante}}" hidden> Próximo Número: {{ $binarioResultante }}</h2>
                            </div>



                            <div class="card-body">
                                <div class="form-group">
                                    <label for="fecha_emision">Fecha de Emisión</label>
                                    {{-- Fecha de Emisión (fecha actual por defecto) --}}
                                    <input type="date" id="fecha_emision" name="fechpedido" class="form-control"
                                        value="{{ now()->format('Y-m-d') }}">
                                </div>
                                <div class="form-group">
                                    <label for="almacen">Almacén</label>
                                    {{-- Almacén dinámico --}}
                                    <select id="almacen" name="almacen" class="form-control">
                                        @foreach ($almacenes as $almacen)
                                            <option value="{{ $almacen->Num_item }}">{{ $almacen->Des_item }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label for="forma_pago">Forma de Pago</label>
                                        {{-- Forma de Pago (opciones estáticas) --}}
                                        <select id="forma_pago" name="forpag" class="form-control">
                                            @foreach ($formasPago as $key => $value)
                                                <option value="{{ $key }}">{{ $value }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label for="condicion_pago">Condición de Pago</label>
                                        {{-- Condición de Pago dinámica --}}
                                        <select id="condicion_pago" name="Cdg_cpag" class="form-control">
                                            <option value="">--seleccione--</option>
                                            @foreach ($condicionesPago as $condicion)
                                                <option value="{{ $condicion->num_item }}">{{ $condicion->des_item }}
                                                </option>
                                            @endforeach
                                        </select>
                                        <span class="text-danger">*obligatorio</span>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="moneda">Moneda</label>
                                    {{-- Moneda dinámica --}}
                                    <select id="moneda" name="Cdg_mon" class="form-control">
                                        @foreach ($monedas as $moneda)
                                            <option value="{{ $moneda->Num_item }}">{{ $moneda->Des_item }}</option>
                                        @endforeach
                                    </select>

                                    <label for="lista_precio">Lista de precios</label>
                                    {{-- Moneda dinámica --}}
                                    <select id="lista_precio" name="Cdg_lpre" class="form-control">
                                        @foreach ($lista_precios as $lista_precio)
                                            <option value="{{ $lista_precio->Num_item }}">{{ $lista_precio->Des_item }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label for="tipo_cambio">Tipo de Cambio</label>
                                        <input type="text" name="tip_cmb" id="moneda" class="form-control" value="{{$valor }}">
                                    </div>
                                </div>



                            </div>
                        </div>
                    </div>

                </div>
            </div>


            <div class="card" id="contenido_cesta" >
                @include('admin.pedidos.cesta')
            </div>

            <!-- Totales -->
            <div class="row mt-3">
                <div class="col-md-6">
                    <div class="form-group">
                        <label for="lugar_entrega">Lugar de Entrega</label>
                        <input name="lug_ent" type="text" id="lugar_entrega" class="form-control">
                    </div>
                    <div class="form-group">
                        <label for="fecha_entrega">Fecha de Entrega</label>
                        <input name= "fec_ent" type="date" id="fecha_entrega" class="form-control">
                    </div>
                    <div class="form-group">
                        <label for="fecha_validez">Fecha de Validez</label>
                        <input name ="tip_val" type="date" id="fecha_validez" class="form-control">
                    </div>
                    <div class="form-group">
                        <label for="observaciones">Observaciones</label>
                        <textarea name= "Obs_ped" id="observaciones" class="form-control" rows="3"></textarea>
                    </div>
                </div>

                <div class="col-md-6">
                    <table class="table table-bordered">
                        <tr>
                            <td>Subtotal:</td>
                            <td>
                                <input type="text" name="subtotal" id="subtotal" class="form-control" value="0.00" readonly>
                            </td>
                        </tr>
                        <tr>
                            <td>% Descuento:</td>
                            <td>
                                <input type="text" name="descuento" id="descuento" value="0" readonly class="form-control">
                            </td>
                        </tr>
                        <tr>
                            <td>Inafecta:</td>
                            <td>
                                <input type="text" name="inafecta" id="inafecta" value="0.00" readonly class="form-control">
                            </td>
                        </tr>
                        <tr>
                            <td>Exonerada:</td>
                            <td>
                                <input type="text" name="exonerada" id="exonerada" value="0.00" readonly class="form-control">
                            </td>
                        </tr>
                        <tr>
                            <td>% IGV:</td>
                            <td>
                                <input type="text" name="igv" id="igv" value="0.00" readonly class="form-control">
                            </td>
                        </tr>
                        <tr>
                            <td><strong>Total Descuento:</strong></td>
                            <td>
                                <input type="text" name="total_descuento" id="total_descuento" value="0.00" readonly class="form-control">
                            </td>
                        </tr>
                        <tr>
                            <td><strong>TOTAL:</strong></td>
                            <td>
                             <input type="text" name="total" id="total" value="0.00" readonly class="form-control">
                            </td>
                        </tr>
                    </table>
                </div>

            </div>

            <!-- Botones -->
            <div class="row mt-3">
                <div class="col-md-12 text-right">
                    <button type="submit" class="btn btn-success">Registrar Cotización</button>
                    <button type="reset" class="btn btn-danger">Cancelar</button>
                </div>
            </div>

        </div>
    </form>
    @include('admin.pedidos.modal-cliente')
    @include('admin.pedidos.modal-producto')
@stop


@section('js')
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap4.min.css">
<!-- DataTables JS -->
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap4.min.js"></script>
<!-- Bootstrap -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>

<script>
    $(document).ready(function(){
        $('#tablaClientes').DataTable({
            "ordering":false,
            "info":false,
            "language":{
                "sLengthMenu":     "Mostrar _MENU_ entradas",
                "sSearch":"Buscar"
            }
        });
    })
    $(document).ready(function(){
        $('#tablaProductosModal').DataTable({
            "ordering":false,
            "info":false,
            "language":{
                "sLengthMenu":     "Mostrar _MENU_ entradas",
                "sSearch":"Buscar"
            }
        });
    })
</script>
<script>
    function seleccionar(num){
            console.log(num);
            let ruc=$('#ruc'+num).val();
            let cliente=$('#des'+num).val();
            let direccion=$('#dir'+num).val();
            let email=$('#email'+num).val();

            $('#ruc_dni').val(ruc);
            $('#nombre_cliente').val(cliente);
            $('#direccion').val(direccion);
            $('#correo').val(email);
        }
    
        let productos=[];
        idunico=1;
        function selecProducto(numero){
            let idproducto=$('#id'+numero).val();
            let descripcion=$('#descripcion'+numero).val();
            let unm=$('#unm'+numero).val();
            let val=$('#val'+numero).val();
            let stk=1.00;
            let afectacion=$('#afectacion'+numero).val();
            let bonific=(afectacion !=15 && afectacion !=31)?'NO':'SI';
            let aval ='';
            if(afectacion == 30 || afectacion==31 || afectacion==32 || afectacion==33 || afectacion==34 || afectacion==35 || afectacion==36){
                aval ='I';
            }else if(afectacion == 20 || afectacion == 21){
                aval ='E';
            }else if(afectacion == 10 || afectacion == 11 || afectacion == 12 || afectacion == 13 || afectacion == 14 || afectacion == 15 || afectacion == 16 || afectacion == 17){
                     aval ='G';
            }else if(afectacion == 40){
                aval ='X';
            }
            /*creamos un objeto*/
            let producto={
                id:idunico,
                codproducto:idproducto,
                descripcion:descripcion,
                unm:unm,
                val:val,
                stk:stk,
                desc:0.00,
                afectacion:afectacion,
                bonific:bonific,
                aval:aval,
                total:0.00
            };
            idunico++;
            productos.push(producto);

            mostrarProducto();
        }
        function mostrarProducto(){
            let afectaciones=@json($afectaciones);
            let nuevafila='';
            let count=0;    
                productos.forEach(producto => {
                    ++count;
                const {id,codproducto,descripcion,unm,val,stk,afectacion,desc,total,bonific,aval}=producto;
                nuevafila +=`<tr>
                            <td class="text-center">
                                <input hidden type='text' name='idS[]' value='${id}'>
                              ${codproducto} <input hidden type='text' name='producto[]' value='${codproducto}'>
                             </td>
                             <td class="text-center">
                              ${descripcion}
                             </td>
                             <td class="text-center">
                              ${unm} <input type='text' hidden name='medida[]' value='${unm}'>
                             </td>
                             <td class="text-center">
                              <input type='text' name='stock[]' id='stock${count}' class="form-control" value='${stk}' onblur=cambiar('${count}')>
                             </td>
                             <td class="text-center">
                              <input type='text' name='preciouni[]' id='preciouni${count}' class="form-control" value='${val}' onblur=cambiar('${count}')>
                             </td>
                             <td class="text-center">
                              <input type='text' name='desc[]' id='desc${count}' class="form-control" value='${desc}' onblur=cambiar('${count}')>
                             </td>
                             <td class="text-center">
                              <input type='text' name='subTotalP[]' id='subTotalP${count}' class="form-control" value='${total}'>
                             </td>
                             <td class="text-center">
                             <input type='text' hidden name='aval[]' id='aval${count}' class="form-control" value='${aval}' readonly>
                              <input type='text' name='bonificacion[]' id='bonificacion${count}' class="form-control" value='${bonific}' readonly>
                             </td>
                             <td class="text-center">
                               <select name="afectacion${count}" id="afectacion${count}" class="form-control" onchange="cambiarafectacion(${count})">
                                <option value="">--seleccione</option>
                                 ${afectaciones.map(afectacione => {
                                 const { COD_AFEC, DES_AFEC } = afectacione;
                                 let selectd =(afectacion==COD_AFEC)?'selected':'';
                                 return `<option value="${COD_AFEC}" ${selectd}>${COD_AFEC} - ${DES_AFEC}</option>`;
                                 }).join('')}  
                               </select>
                             </td>
                             <td class="text-center">
                               <span class="btn btn-danger" onclick="eliminar('${count}')"><i class="fa fa-trash" aria-hidden="true"></i></span>
                             </td>
                             </tr>
                             `               
            });
          

            $('#productosel').html(nuevafila);
            calcular()
        }

        function cambiar(ope){
            let stock=parseFloat($('#stock'+ope).val());
            let preciouni=parseFloat($('#preciouni'+ope).val());
            let descuento=parseFloat($('#desc'+ope).val());
            let total=0.00;

            total=(stock*preciouni) * (1 - descuento/100);

            productos[ope-1].stk=stock;
            productos[ope-1].val=preciouni;
            productos[ope-1].desc=descuento;
            productos[ope-1].total=total;
            $("#subTotalP"+ope).val(total.toFixed(2));
            calcular()
        }

        function calcular(){
            let sumaTotal=0.00;
            let sumasubtotal=0.00;
            let sumadescuento=0.00;
            let sumaporcentaje=0.00;
            let totalIGV=0.00;
            let sumainafecta=0.00;
            let sumaexonerada=0.00;
            /**/
            let sumainafectaT=0.00;
            let sumaexoneradaT=0.00;
            let sumasubtotalT=0.00;
            
            let sumasubtotalB=0.00;
            let totalIGVT=0.00;
            
            productos.forEach(producto=>{
                if(producto.afectacion == 30 || producto.afectacion==31 || producto.afectacion==32 || producto.afectacion==33 || producto.afectacion==34 || producto.afectacion==35 || producto.afectacion==36){
                    sumainafectaT +=producto.total;
                }else if(producto.afectacion == 20 || producto.afectacion == 21){
                    sumaexoneradaT +=producto.total;
                }else if(producto.afectacion == 10 || producto.afectacion == 17){
                    sumasubtotalT +=producto.total;
                    totalIGVT =sumasubtotalT*0.18;
                }else if(producto.afectacion == 40){
                    sumasubtotalT +=producto.total;
                    totalIGVT =sumasubtotalT*0;
                }else{
                    sumasubtotalB=0.00;
                }
                sumasubtotal =sumasubtotalT;
                totalIGV=totalIGVT;
                sumainafecta=sumainafectaT;
                sumaexonerada=sumaexoneradaT;
                if(totalIGVT==0){
                    sumaTotal=sumasubtotal ;
                }else{
                    sumaTotal=1.18*sumasubtotal + sumainafecta+ sumaexonerada;
                }
                sumaporcentaje +=producto.desc;
                sumadescuento +=(producto.stk*producto.val)*0.01*producto.desc;
            })
            
            $('#subtotal').val(sumasubtotal.toFixed(2));
            $('#descuento').val(sumaporcentaje.toFixed(2));
            $('#inafecta').val(sumainafecta.toFixed(2));
            $('#exonerada').val(sumaexonerada.toFixed(2));
            $('#igv').val(totalIGV.toFixed(2));
            $('#total_descuento').val(sumadescuento.toFixed(2));
            $('#total').val(sumaTotal.toFixed(2));
        }

        function cambiarafectacion(ope){
            let afectacion=$('#afectacion'+ope).val();
            let bonific=(afectacion !=15 && afectacion !=31)?'NO':'SI';
            let aval ='';
            if(afectacion == 30 || afectacion==31 || afectacion==32 || afectacion==33 || afectacion==34 || afectacion==35 || afectacion==36){
                aval ='I';
            }else if(afectacion == 20 || afectacion == 21){
                aval ='E';
            }else if(afectacion == 10 || afectacion == 11 || afectacion == 12 || afectacion == 13 || afectacion == 14 || afectacion == 15 || afectacion == 16 || afectacion == 17){
                     aval ='G';
            }else if(afectacion == 40){
                aval ='X';
            }
            $('#bonificacion'+ope).val(bonific);
            productos[ope-1].afectacion=afectacion;
            productos[ope-1].bonific=bonific;
            productos[ope-1].aval=aval;
            calcular()
        }

        function eliminar(posicion){
            let iditem=productos[posicion - 1].id;
            let productActualizado=productos.filter(producto=> producto.id !=iditem);
            productos=productActualizado;

            mostrarProducto();
        }
        function limpiar(){
            productos=[];
            mostrarProducto();
        }
</script>
@stop 