@extends('adminlte::page')

@section('title', 'Listado de Distribuidores')

@section('content_header')

    @if (!empty($cod_patro) && $cod_patro!=NULL)
      @if ($estado)
      <a class="btn btn-primary float-right mb-3 mb-md-0" href="{{ route('admin.distribuidores.create') }}">
        <i class="fas fa-plus-circle"></i> Registrar Distribuidor
      </a>
      @else
          
      @endif
    @else  
    <a class="btn btn-primary float-right mb-3 mb-md-0" href="{{ route('admin.distribuidores.create') }}">
        <i class="fas fa-plus-circle"></i> Registrar Distribuidor
    </a>
    @endif

    <h1 class="text-bold">Lista de Distribuidores</h1>
@stop

@section('content')
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            {{-- Buscador --}}
            <form action="{{ route('admin.distribuidores.index') }}" method="GET" class="d-flex"
                style="gap: 10px; width: 50%;">
                <input name="search" class="form-control" type="text" placeholder="Buscar por Código o Nombre"
                    value="{{ request('search') }}">
                <button class="btn btn-primary" type="submit">Buscar</button>
            </form>

            {{-- Paginador --}}
            @include('admin.paginador.index', ['data' => $data])
        </div>

        {{-- Tabla de Distribuidores --}}
        @if ($data['distribuidores']->count())
            <div class="card-body">
                <form id="estadoForm" method="POST">
                    @csrf
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead class="border text-center">
                                <tr>
                                    <th><input type="checkbox" id="selectAll"></th>
                                    <th>ID</th>
                                    <th>Código</th>
                                    <th>Nombre</th>
                                    <th>Dirección</th>
                                    <th>Teléfono</th>
                                    <th>Email</th>
                                    <th>Estado Web</th>
                                    {{-- <th>Estado ERP</th> --}}
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($data['distribuidores'] as $index => $distribuidor)
                                    <tr>
                                        <td class="text-center">
                                            <input type="checkbox" class="distribuidorCheckbox"
                                                value="{{ $distribuidor->cdg_dist }}">
                                        </td>
                                        <td>{{ $data['tamanio'] * ($data['pagina'] - 1) + $loop->iteration }}</td>
                                        <td>{{ $distribuidor->cdg_dist }}</td>
                                        <td>{{ $distribuidor->NOM_DIS }}</td>
                                        <td>{{ $distribuidor->dir_dist }}</td>
                                        <td>{{ $distribuidor->tel_dist }}</td>
                                        <td>{{ $distribuidor->ema_dist }}</td>
                                        <td class="text-center">
                                            @if ($distribuidor->estado_web == '1')
                                                <span class="badge bg-success">Activo</span>
                                            @else
                                                <span class="badge bg-danger">Inactivo</span>
                                            @endif
                                        </td>
                                        {{-- <td class="text-center">
                                                @php
                                                    $estado=($distribuidor->ESTADO == 'ACTIVO') ? 'bg-success' : 'bg-danger';
                                                @endphp
                                               <form action="{{route('admin.distribuidores.activo',[$distribuidor->cdg_dist])}}" method="POST">
                                                @method('PUT')
                                                @csrf
                                                    <button type="submit" class="btn {{$estado}}">
                                                       {{ $distribuidor->ESTADO }} 
                                                    </button>
                                               </form>
                                        </td> --}}
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <button type="button" class="btn btn-primary mt-3" id="activarSeleccionados">Activar Seleccionados</button>
                    <button type="button" class="btn btn-danger mt-3" id="desactivarSeleccionados">Desactivar
                        Seleccionados</button>
                </form>
            </div>
        @else
            <div class="card-body">
                <strong>Sin registros</strong>
            </div>
        @endif
    </div>


@stop

@section('js')
@include('admin.distribuidores.activacion-cuenta-web')
@stop 