<script>
    $(document).ready(function() {
    // Seleccionar/Deseleccionar todos los checkboxes al seleccionar/deseleccionar el checkbox "selectAll"
    $('#selectAll').on('change', function() {
        $('.distribuidorCheckbox').prop('checked', $(this).prop('checked'));
    });

    // Manejar la activación/desactivación masiva de distribuidores
    $('#activarSeleccionados').on('click', function() {
        let selected = [];
        $('.distribuidorCheckbox:checked').each(function() {
            selected.push($(this).val());
        });

        if (selected.length > 0) {
            // Llamada AJAX para activar seleccionados
            cambiarEstadoWebMasivo(selected, 1); // 1 para activar
        } else {
            
Swal.fire
({
                title: 'Atención',
                text: 'No se seleccionaron distribuidores.',
                icon: 'warning',
                confirmButtonText: 'Aceptar'
            });
        }
    });

    $('#desactivarSeleccionados').on('click', function() {
        let selected = [];
        $('.distribuidorCheckbox:checked').each(function() {
            selected.push($(this).val());
        });

        if (selected.length > 0) {
            // Llamada AJAX para desactivar seleccionados
            cambiarEstadoWebMasivo(selected, 0); // 0 para desactivar
        } else {
            
Swal.fire
({
                title: 'Atención',
                text: 'No se seleccionaron distribuidores.',
                icon: 'warning',
                confirmButtonText: 'Aceptar'
            });
        }
    });
});


// Función AJAX
function cambiarEstadoWebMasivo(selected, estado) {
    $.ajax({
        type: 'POST',
        url: "{{ route('admin.distribuidores.cambiarEstadoWebMasivo') }}",
        data: {
            cod_distribs: selected,
            estado: estado,
            _token: "{{ csrf_token() }}"
        },
        success: function(response) {
            
Swal.fire
('Estado cambiado', response.message, 'success').then(() => location.reload());
        },
        error: function() {
            
Swal.fire
('Error', 'No se pudo cambiar el estado', 'error');
        }
    });
}

</script> 