@extends('adminlte::page')

@section('title', 'Nuevo Cambio')

@section('content_header')
    <h1>Precio Cambio de Moneda</h1>
@endsection

@section('content')
    <form action="{{ route('admin.cambio.store') }}" method="POST">
        @csrf
        {{--<div class="form-group">
            <label for="Fec_cmb">Fecha </label>
            <input type="text" name="Fec_cmb" id="Fec_cmb" class="form-control" value="{{ now()->format('Y-m-d H:i:s.000') }}" readonly>
            <!-- Campo oculto para asegurarnos de que se envíe -->

        </div>--}}

        <input type="text" name="Fec_cmb" id="Fec_cmb" class="form-control" value="{{ now()->format('Y-m-d H:i:s.000') }}" readonly>
        <input type="hidden" name="Fec_cmb" value="{{ now()->format('Y-m-d H:i:s.000') }}">
        <div class="form-group">
            <label for="Tip_cmb">Cambio Venta</label>
            <input type="number" name="Tip_cmb" id="Tip_cmb" class="form-control" placeholder="0.000" step="0.001" required>
        </div>
        <div class="form-group">
            <label for="Tip_cmp">Cambio Compra</label>
            <input type="number" name="Tip_cmp" id="Tip_cmp" class="form-control" placeholder="0.000" step="0.001" required>
        </div>
        <div class="form-group">
            <label for="Cob_cmb">Cambio Cobranza</label>
            <input type="number" name="Cob_cmb" id="Cob_cmb" class="form-control" placeholder="0.000" step="0.001" required>
        </div>
        {{--<div class="form-group">
            <label for="Cie_vta">Cie_vta</label>
            <input type="number" name="Cie_vta" id="Cie_vta" class="form-control" placeholder="0.000" step="0.001">
        </div>
        <div class="form-group">
            <label for="Cie_cmp">Cie_cmp</label>
            <input type="number" name="Cie_cmp" id="Cie_cmp" class="form-control" placeholder="0.000" step="0.001">
        </div>--}}
        <button type="submit" class="btn btn-success">Guardar</button>
        <a href="{{ route('admin.cambio.index') }}" class="btn btn-secondary">Cancelar</a>
    </form>
@endsection

@section('js')

    <script>
    document.querySelectorAll('input[type="number"]').forEach(input => {
        input.addEventListener('blur', function () {
            if (this.value) {
                // Completa a 3 decimales
                this.value = parseFloat(this.value).toFixed(3);
            }
        });
    });
</script>
@stop
