<?php

use Illuminate\Contracts\Http\Kernel;
use Illuminate\Http\Request;

define('LARAVEL_START', microtime(true));

// Verificar si la aplicación está en modo de mantenimiento
if (file_exists($maintenance = __DIR__.'/../storage/framework/maintenance.php')) {
    require $maintenance;
}

// Registrar el cargador automático de Composer
require __DIR__.'/../vendor/autoload.php';

// Inicializar Laravel
$app = require_once __DIR__.'/../bootstrap/app.php';

// Crear el Kernel HTTP
$kernel = $app->make(Kernel::class);

// Capturar y manejar la solicitud
$request = Request::capture();
$response = $kernel->handle($request);

// Enviar la respuesta al cliente
$response->send();

// Terminar el Kernel (realiza tareas posteriores a la respuesta)
$kernel->terminate($request, $response);
