<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Pais extends Model
{
    use HasFactory;

    protected $connection = 'sqlsrv';
    protected $table = 'dbo.m_pais';
    protected $primaryKey = ['cdg_pais', 'pais_id'];
    public $incrementing = false;
    protected $keyType = 'string';

    protected $fillable = [
        'cdg_pais', 'des_pais', 'pais_id',
    ];

    // Relación: Un país tiene muchas provincias
    
    public function provincias()
    {
        return $this->hasMany(Provincia::class, 'cdg_pais', 'cdg_pais');
    }

    public function departamentos()
    {
        return $this->hasMany(Departamento::class, 'cdg_pais', 'cdg_pais');
    }

    public function distritos()
    {
        return $this->hasMany(Departamento::class, 'cdg_pais', 'cdg_pais');
    }

    public function scopePais($query){
        $query->where('pais_id','9589');
    }
    
}
