<?php

namespace App\Livewire;

use App\Models\User;
use Livewire\WithPagination;
use Livewire\Component;

class UsersIndex extends Component
{
    use WithPagination;
    public $search;

    protected $paginationTheme = "bootstrap";

    public function updatingSearch($value)
    {
        $this->search = trim($value);  // Remover espacios antes y después
        $this->resetPage();  // Reinicia la página
    }

    public function render()
    {
        $users = User::where('name', 'LIKE', '%' . trim($this->search) . '%')
    ->paginate(10);


        return view('livewire.users-index', compact('users'));
    }
} 