<?php

namespace App\Http\Livewire;

use Livewire\Component;
use Livewire\WithPagination;
use App\Models\Producto;

class ProductosTable extends Component
{
    use WithPagination;

    public $search = ''; // Campo de búsqueda
    public $perPage = 10; // Número de elementos por página
    public $sortField = 'id'; // Campo para ordenar
    public $sortDirection = 'asc'; // Dirección de orden

    protected $queryString = ['search', 'sortField', 'sortDirection', 'perPage'];

    public function updatingSearch()
    {
        $this->resetPage(); // Reinicia la paginación al buscar
    }

    public function sortBy($field)
    {
        if ($this->sortField === $field) {
            $this->sortDirection = $this->sortDirection === 'asc' ? 'desc' : 'asc';
        } else {
            $this->sortField = $field;
            $this->sortDirection = 'asc';
        }
    }

    public function render()
{
    $productos = Producto::query()
        ->select(['Cdg_prod', 'Des_prod', 'Cdg_linp', 'Cdg_tprd', 'Val_sol', 'Swt_prod']) // Solo traer las columnas necesarias
        ->where('Des_prod', 'like', '%' . $this->search . '%')
        ->orWhere('Cdg_prod', 'like', '%' . $this->search . '%')
        ->orderBy($this->sortField, $this->sortDirection)
        ->paginate($this->perPage);

    return view('livewire.productos-table', [
        'productos' => $productos,
    ]);
}

}

