<?php

namespace App\Livewire\Productos;

use Livewire\Component;
use Livewire\WithPagination;
use Illuminate\Support\Facades\DB;

class Lista extends Component
{
    use WithPagination;

    public $search = ''; // Campo de búsqueda
    public $selectedAlmacen = ''; // Filtro por almacén
    public $almacenes = []; // Lista de almacenes
    protected $paginationTheme = 'bootstrap'; // Estilo de AdminLTE

    public function mount()
    {
        // Cargar almacenes disponibles
        $this->almacenes = DB::connection('sqlsrv')
            ->table('d_tablas')
            ->where('Cdg_tab', 'ARE')
            ->select('Num_item', 'Des_item')
            ->get();
    }

    public function buscar()
    {
        // Reiniciar la paginación al buscar
        $this->resetPage();
    }

    public function buscarPorAlmacen()
    {
        // Reiniciar la paginación al filtrar por almacén
        $this->resetPage();
    }

    public function updatingSearch()
    {
        // Reiniciar la paginación al actualizar el campo de búsqueda
        $this->resetPage();
    }

    public function render()
    {
        // Construir la consulta para obtener los productos
        $query = DB::connection('sqlsrv')
    ->table('m_produc')
    ->join('d_tablas', function ($join) {
        $join->on('m_produc.Cdg_linp', '=', 'd_tablas.Num_item')
             ->where('d_tablas.Cdg_tab', '=', 'LIN');
    })
    ->join('d_tablas AS d1', function ($join) {
        $join->on('m_produc.Cdg_tprd', '=', 'd1.Num_item')
             ->where('d1.Cdg_tab', '=', 'TPR');
    })
    ->leftJoin('d_tablas AS d2', function ($join) {
        $join->on('m_produc.CDG_FMA', '=', 'd2.Num_item')
             ->where('d2.Cdg_tab', '=', 'CLA');
    })
    ->join('d_tablas AS d3', function ($join) {
        $join->on('m_produc.Cdg_umed', '=', 'd3.Num_item')
             ->where('d3.Cdg_tab', '=', 'UNM');
    })
    ->join('m_stock', 'm_produc.Cdg_prod', '=', 'm_stock.Cdg_prod')
    ->join('d_tablas AS d4', function ($join) {
        $join->on('m_stock.Cdg_area', '=', 'd4.Num_item')
             ->where('d4.Cdg_tab', '=', 'ARE');
    })
    ->select(
        'm_produc.Cdg_prod',
        'm_produc.Des_prod',
        'd_tablas.Des_item AS Familia',
        'd1.Des_item AS Linea',
        DB::raw("ISNULL(d2.Des_item, 'Sin Registro') AS Tipo"),
        'd3.Abr_item AS UNM',
        'm_produc.Val_sol',
        'm_produc.Val_dol',
        'm_stock.Stk_act',
        'm_produc.swt_est',
        'd4.Des_item'
    );


        // Filtro por almacén
        if (!empty($this->selectedAlmacen)) {
            $query->where('d4.Num_item', $this->selectedAlmacen);
        }

        // Filtro por búsqueda
        if (!empty($this->search)) {
            $query->where(function ($subQuery) {
                $subQuery->where('m_produc.Des_prod', 'LIKE', "%{$this->search}%")
                    ->orWhere('m_produc.Cdg_prod', 'LIKE', "%{$this->search}%");
            });
        }

        // Obtener resultados paginados
        $productos = $query->paginate(10);

        return view('livewire.productos.lista', [
            'productos' => $productos,
        ]);
    }
}
