<?php

namespace App\Livewire\Pedidos;

use Livewire\Component;
use Livewire\WithPagination;
use Illuminate\Support\Facades\DB;

class Lista extends Component
{
    use WithPagination;

    public $search = ''; // Campo de búsqueda
    protected $paginationTheme = 'bootstrap'; // Estilo de AdminLTE

    public function buscar()
    {
        // Reiniciar la paginación al buscar
    }

    public function updatingSearch()
    {
        // Reiniciar la paginación al buscar
        $this->resetPage();
    }

    public function render()
    {
        // Construir la consulta para obtener los pedidos
        $query = DB::connection('sqlsrv')
            ->table('m_pedido')
            ->join('m_vended', 'm_pedido.Cdg_vend', '=', 'm_vended.Cdg_vend')
            ->join('d_tablas as d1', 'm_pedido.Cdg_cpag', '=', 'd1.Num_item')
            ->join('d_tablas as d2', 'm_pedido.Cdg_mon', '=', 'd2.Num_item')
            ->join('m_client', 'm_pedido.Ruc_cli', '=', 'm_client.Ruc_cli')
            ->join('d_tablas as d3', 'm_pedido.Ori_area', '=', 'd3.Num_item')
            ->select(
                'm_pedido.Num_ped',
                'm_vended.Des_vend',
                DB::raw("(CASE WHEN m_pedido.FOR_PAG = 1 THEN 'CONTADO' ELSE 'CREDITO' END) AS FORMA_PAGO"),
                'd1.Des_item AS FOR_PAGO',
                'd2.Des_item AS MONEDA',
                'm_pedido.Fec_ped',
                'm_pedido.Num_ocom',
                'm_pedido.Num_cot',
                'm_pedido.Ruc_cli',
                'm_client.Des_cli',
                'm_pedido.FEC_ENT',
                'm_pedido.FEC_VENC',
                'd3.Des_item AS ALMACEN'
            )
            ->where('d1.Cdg_tab', 'FPA')
            ->where('d1.Cam_item', 'X')
            ->where('d2.Cdg_tab', 'MON')
            ->where('d3.Cdg_tab', 'ARE');

        // Aplicar filtro de búsqueda
        if (!empty($this->search)) {
            $query->where(function ($subQuery) {
                $subQuery->where('m_vended.Des_vend', 'LIKE', "%{$this->search}%")
                    ->orWhere('m_pedido.Num_ped', 'LIKE', "%{$this->search}%");
            });
        }

        // Obtener resultados paginados
        $pedidos = $query->paginate(10);

        return view('livewire.pedidos.lista', [
            'pedidos' => $pedidos,
        ]);
    }
}
