<?php

namespace App\Livewire\Clientes;

use Livewire\Component;
use Illuminate\Support\Facades\DB;

class Formulario extends Component
{
    public $cliente = [
        'codigo' => '',
        'tipo_documento' => '',
        'documento' => '',
        'nombres_razon' => '',
        'direccion' => '',
        'telefono' => '',
        'contacto' => '',
        'activo' => 0,
        'agente_retendedor' => 0,
        'pais' => '',
        'departamento' => '',
        'provincia' => '',
        'distrito' => '',
        'cdg_dsto' => '', // Código concatenado
        'tipo_cliente' => 'Persona Juridica',
    ];

    public $paises = [];
    public $departamentos = [];
    public $provincias = [];
    public $distritos = [];

    public function mount()
    {
        $this->paises = DB::connection('sqlsrv')->table('m_pais')->pluck('des_pais', 'cdg_pais')->toArray();
        $this->departamentos = DB::connection('sqlsrv')->table('m_dptos')->pluck('des_dpto', 'cdg_dpto')->toArray();
        $this->provincias = DB::connection('sqlsrv')->table('m_prov')->pluck('des_prov', 'cdg_prov')->toArray();
        $this->distritos = DB::connection('sqlsrv')->table('m_dsto')->pluck('des_dsto', 'cdg_dsto')->toArray();
    }

    public function updatedClienteDepartamento()
    {
        $this->actualizarCdgDsto();
    }

    public function updatedClienteProvincia()
    {
        $this->actualizarCdgDsto();
    }

    public function updatedClienteDistrito()
    {
        $this->actualizarCdgDsto();
    }

    private function actualizarCdgDsto()
    {
        // Concatenar los códigos de departamento, provincia y distrito
        $this->cliente['cdg_dsto'] = trim("{$this->cliente['departamento']}{$this->cliente['provincia']}{$this->cliente['distrito']}");
    }

    public function save()
    {
        $this->validate([
            'cliente.documento' => 'required|max:20',
            'cliente.nombres_razon' => 'required|max:60',
            'cliente.direccion' => 'nullable|max:180',
            'cliente.telefono' => 'nullable|max:20',
            'cliente.pais' => 'required',
            'cliente.departamento' => 'required',
            'cliente.provincia' => 'required',
            'cliente.distrito' => 'required',
        ]);

        try {
            DB::connection('sqlsrv')->statement('EXEC USP_WEB_INSERT_CLIENTE
                @modo = ?, @RUC_CLI = ?, @Des_cli = ?, @Dir_cli = ?, @Tel_cli = ?, @Fax_cli = ?,
                @Ema_cli = ?, @Rep_cli = ?, @Crd_sol = ?, @Crd_dol = ?, @Cdg_tcli = ?, @Cdg_vend = ?,
                @Swt_cli = ?, @Swt_alt = ?, @Cdg_alt = ?, @Doc_leg = ?, @Rep_leg = ?, @Swt_ret = ?,
                @Swt_cred = ?, @Swt_susp = ?, @Web_cli = ?, @cdg_lprc = ?, @cdg_cpag = ?, @Swt_ext = ?,
                @cdg_docum = ?, @cdg_pais = ?, @cdg_dsto = ?, @dni_cli = ?, @cdg_suc = ?, @cdg_cent = ?,
                @cent_cons = ?, @SWT_PERC = ?', [
                $this->cliente['codigo'] ? 2 : 1,
                $this->cliente['codigo'] ?? '',
                $this->cliente['nombres_razon'],
                $this->cliente['direccion'],
                $this->cliente['telefono'],
                '', // Fax
                '', // Email
                $this->cliente['contacto'],
                0, // Crédito en soles
                0, // Crédito en dólares
                $this->cliente['tipo_cliente'] == 'Persona Juridica' ? '001' : '002',
                '', // Vendedor
                $this->cliente['activo'] ? 1 : 0,
                0, // Alternativo
                '', // Código alternativo
                '', // Documento legal
                '', // Representante legal
                $this->cliente['agente_retendedor'] ? 1 : 0,
                0, // Crédito
                0, // Suspensión
                '', // Web
                '', // Lista de precios
                '', // Condiciones de pago
                0, // Externo
                $this->cliente['tipo_documento'],
                $this->cliente['pais'],
                $this->cliente['cdg_dsto'], // Código concatenado
                $this->cliente['documento'],
                '', // Sucursal
                '', // Centro
                0, // Centro de consumo
                0, // Percepción
            ]);

            session()->flash('message', 'Cliente guardado exitosamente.');
            $this->reset('cliente');
        } catch (\Exception $e) {
            session()->flash('error', 'Error al guardar el cliente: ' . $e->getMessage());
        }
    }

    public function render()
    {
        return view('livewire.clientes.formulario', [
            'paises' => $this->paises,
            'departamentos' => $this->departamentos,
            'provincias' => $this->provincias,
            'distritos' => $this->distritos,
        ]);
    }
}
