<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Pagination\Paginator;

class ProductosController extends Controller
{
    public function index(Request $request)
{
    $search = $request->get('search', ''); // Término de búsqueda
    $almacen = $request->get('almacen', ''); // Almacén seleccionado
    $tamanio = $request->get('tamanio', 10); // Tamaño de página
    $pagina = $request->get('pagina', 1); // Página actual
    $order_by = $request->get('order_by', 'Cdg_prod'); // Columna para ordenar
    $direction = $request->get('direction', 'asc');

    // Obtener todos los almacenes
    $almacenes = DB::connection('sqlsrv')->table('d_tablas')
        ->where('Cdg_tab', 'ARE') // Relacionado con los almacenes
        ->select('Num_item', 'Des_item')
        ->get();

    // Llamar al procedimiento almacenado para productos
    $query = "EXEC USP_WEB_SELECT_PRODUCTOS";
    $productos = DB::connection('sqlsrv')->select($query);

    // Convertir resultados a una colección
    $productosCollection = collect($productos);

    // Aplicar filtro por almacén
    if (!empty($almacen)) {
        $productosCollection = $productosCollection->filter(function ($producto) use ($almacen) {
            return strcasecmp(trim($producto->Almacen), $almacen) === 0;
        });
    }

    // 2. Aplicar filtro de búsqueda
    if (!empty($search)) {
        $productosCollection = $productosCollection->filter(function ($producto) use ($search) {
            return str_contains(strtolower($producto->Cdg_prod), strtolower($search)) ||
                   str_contains(strtolower($producto->Des_prod), strtolower($search)) ||
                   str_contains(strtolower($producto->Familia), strtolower($search)) ||
                   str_contains(strtolower($producto->Linea), strtolower($search));
        });
    }

    // Obtener los almacenes relacionados con los productos filtrados
    $almacenesRelacionados = $productosCollection->pluck('Almacen')->unique();

    // Ordenar y paginar resultados
    $productosCollection = $productosCollection->sortBy($order_by, SORT_REGULAR, $direction === 'desc');
    $total = $productosCollection->count();
    $items = $productosCollection->forPage($pagina, $tamanio);
    $paginados = new \Illuminate\Pagination\LengthAwarePaginator($items, $total, $tamanio, $pagina);

    // Retornar datos a la vista
    $data = [
        'items' => $paginados,
        'total' => $total,
        'pagina' => $pagina,
        'tamanio' => $tamanio,
        'total_paginas' => ceil($total / $tamanio),
        'search' => $search,
        'almacen' => $almacen,
        'order_by' => $order_by,
        'direction' => $direction,
    ];

    return view('admin.productos.index', compact('data', 'almacenesRelacionados', 'almacenes'));
}








    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.productos.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
