<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class CambioController extends Controller
{
    public function index()
    {
        // Obtener los datos de la tabla para mostrar en la vista
        $cambios = DB::connection('sqlsrv')->table('t_cambio')->take(1000)->get();
        return view('admin.cambio.index', compact('cambios'));
    }

    public function create()
    {
        // Mostrar el formulario para crear un nuevo registro
        return view('admin.cambio.create');
    }



public function store(Request $request)
{
    // Validar los datos del formulario
    $request->validate([
        'Fec_cmb' => 'nullable|date',                // Fecha opcional
        'Tip_cmb' => 'required|numeric|min:0',       // Tip_cmb requerido
        'Tip_cmp' => 'required|numeric|min:0',       // Tip_cmp requerido
        'Cob_cmb' => 'required|numeric|min:0',       // Cob_cmb requerido
        'Cie_vta' => 'nullable|numeric|min:0',       // Cie_vta opcional
        'Cie_cmp' => 'nullable|numeric|min:0',       // Cie_cmp opcional
    ]);

    // Formatear la fecha proporcionada o usar NULL
    $fec_cmb = $request->Fec_cmb
    ? Carbon::parse($request->Fec_cmb)->format('Y-m-d H:i:s.000') // Formatear fecha
    : null; // Usar NULL si no se proporciona fecha


    // Formatear los valores decimales
    $tip_cmb = number_format((float)$request->Tip_cmb, 3, '.', '');
    $tip_cmp = number_format((float)$request->Tip_cmp, 3, '.', '');
    $cob_cmb = number_format((float)$request->Cob_cmb, 3, '.', '');
    $cie_vta = number_format((float)($request->Cie_vta ?? 0.000), 3, '.', '');
    $cie_cmp = number_format((float)($request->Cie_cmp ?? 0.000), 3, '.', '');

    try {
        // Llamar al procedimiento almacenado
        DB::connection('sqlsrv')->statement('EXEC USP_WEB_INSERT_CAMBIO ?, ?, ?, ?, ?, ?', [
            $fec_cmb,
            $tip_cmb,
            $tip_cmp,
            $cob_cmb,
            $cie_vta,
            $cie_cmp,
        ]);

        return redirect()->route('cambio.index')->with('success', 'Registro creado exitosamente.');
    } catch (\Exception $e) {
        // Capturar errores y mostrarlos al usuario
        return redirect()->back()->withErrors(['error' => $e->getMessage()]);
    }
}



}
